/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.util.Cache;
import org.zkoss.util.FastReadCache;
import org.zkoss.util.resource.Location;
import org.zkoss.xml.Locators;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.annotation.ComponentAnnotation;
import org.zkoss.zk.ui.metainfo.AnnotationMap;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.DefinitionNotFoundException;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.impl.AnnotationHelper;
import org.zkoss.zk.ui.sys.ExecutionCtrl;

class Impls {
    static final String DEFAULT = "default";
    private static Boolean _dupListenerIgnored;
    private static transient Cache<String, String> _defMolds;
    private static final Pattern _rprop;
    private static transient Cache<String, Object> _defAnnots;

    Impls() {
    }

    static ComponentDefinition getDefinition(Execution exec, Class<? extends Component> cls) {
        if (exec != null) {
            ComponentDefinition compdef;
            ExecutionCtrl execCtrl = (ExecutionCtrl)((Object)exec);
            PageDefinition pgdef = execCtrl.getCurrentPageDefinition();
            Page page = execCtrl.getCurrentPage();
            ComponentDefinition componentDefinition = pgdef != null ? pgdef.getComponentDefinition(cls, true) : (compdef = page != null ? page.getComponentDefinition(cls, true) : null);
            if (compdef != null && compdef.getLanguageDefinition() != null) {
                return compdef;
            }
            ComponentDefinition compdef2 = Components.getDefinitionByDeviceType(exec.getDesktop().getDeviceType(), cls);
            return compdef != null && (compdef2 == null || !Objects.equals((Object)compdef.getImplementationClass(), (Object)compdef2.getImplementationClass())) ? compdef : compdef2;
        }
        for (String deviceType : LanguageDefinition.getDeviceTypes()) {
            ComponentDefinition compdef = Components.getDefinitionByDeviceType(deviceType, cls);
            if (compdef == null) continue;
            return compdef;
        }
        return null;
    }

    static ComponentDefinition getDefinitionByDeviceType(Component comp, String deviceType, String name) {
        for (LanguageDefinition ld : LanguageDefinition.getByDeviceType(deviceType)) {
            try {
                ComponentDefinition def = ld.getComponentDefinition(name);
                if (!def.isInstance(comp)) continue;
                return def;
            }
            catch (DefinitionNotFoundException definitionNotFoundException) {
            }
        }
        return null;
    }

    static boolean duplicateListenerIgnored() {
        if (_dupListenerIgnored == null) {
            _dupListenerIgnored = "true".equals(Library.getProperty((String)"org.zkoss.zk.ui.EventListener.duplicateIgnored"));
        }
        return _dupListenerIgnored;
    }

    static String defaultMold(Class<? extends Component> klass) {
        String clsnm = klass.getName();
        String mold = (String)_defMolds.get((Object)clsnm);
        if (mold == null) {
            mold = Library.getProperty((String)(clsnm + ".mold"), (String)DEFAULT);
            _defMolds.put((Object)clsnm, (Object)mold);
        }
        return mold;
    }

    static AnnotationMap getClassAnnotationMap(Class<?> klass) {
        if (klass == null) {
            return null;
        }
        String clsnm = klass.getName();
        Object val = _defAnnots.get((Object)clsnm);
        if (val == null) {
            AnnotationMap annots = new AnnotationMap();
            annots.addAll(Impls.getClassAnnotationMap(klass.getSuperclass()));
            Impls.loadClassAnnots(annots, klass);
            val = annots.isEmpty() ? Objects.UNKNOWN : annots;
            _defAnnots.put((Object)clsnm, val);
        }
        return val instanceof AnnotationMap ? (AnnotationMap)val : null;
    }

    private static void loadClassAnnots(AnnotationMap annots, Class<?> klass) {
        if (klass == null) {
            return;
        }
        ComponentAnnotation jannot = klass.getAnnotation(ComponentAnnotation.class);
        if (jannot != null) {
            Impls.loadClassAnnots(annots, jannot, null, new Loc(klass.getName()));
        }
        Method[] mtds = klass.getDeclaredMethods();
        for (int j = 0; j < mtds.length; ++j) {
            jannot = mtds[j].getAnnotation(ComponentAnnotation.class);
            if (jannot == null) continue;
            Loc loc = new Loc(mtds[j].toString());
            String prop = Impls.getMethodProp(mtds[j]);
            if (prop == null) {
                throw new UiException(loc.format("Component annotations allowed only for public getter or setter"));
            }
            Impls.loadClassAnnots(annots, jannot, prop, loc);
        }
    }

    private static void loadClassAnnots(AnnotationMap annots, ComponentAnnotation jannot, String prop, Location loc) {
        AnnotationHelper annHelper = new AnnotationHelper();
        String[] values = jannot.value();
        for (int j = 0; j < values.length; ++j) {
            String name = prop;
            String value = values[j];
            Matcher m = _rprop.matcher(value);
            if (m.matches()) {
                name = m.group(1);
                value = m.group(2);
            }
            if (!AnnotationHelper.isAnnotation(value)) {
                throw new UiException(loc.format("Invalid annotation: " + value));
            }
            annHelper.addByCompoundValue(value, loc);
            annHelper.applyAnnotations(annots, name, true);
        }
    }

    private static String getMethodProp(Method mtd) {
        if (Modifier.isPublic(mtd.getModifiers())) {
            String nm = mtd.getName();
            int len = nm.length();
            switch (mtd.getParameterTypes().length) {
                case 0: {
                    if (len >= 4 && nm.startsWith("get")) {
                        return Character.toLowerCase(nm.charAt(3)) + nm.substring(4);
                    }
                    if (len < 3 || !nm.startsWith("is")) break;
                    return Character.toLowerCase(nm.charAt(2)) + nm.substring(3);
                }
                case 1: {
                    if (len < 4 || !nm.startsWith("set")) break;
                    return Character.toLowerCase(nm.charAt(3)) + nm.substring(4);
                }
            }
        }
        return null;
    }

    static {
        _defMolds = new FastReadCache(100, 14400000);
        _rprop = Pattern.compile(" *([a-zA-Z0-9_$]*) *: *(.*) *");
        _defAnnots = new FastReadCache(100, 14400000);
    }

    private static class Loc
    implements Location,
    Serializable {
        final String _path;

        private Loc(String path) {
            this._path = path;
        }

        public String getPath() {
            return this._path;
        }

        public int getLineNumber() {
            return -1;
        }

        public int getColumnNumber() {
            return -1;
        }

        public String format(String message) {
            return Locators.format((String)message, (String)this._path, null, (int)-1, (int)-1);
        }
    }
}

